/*
 * Decompiled with CFR 0.152.
 */
package cds.xml;

import cds.aladin.MyInputStream;
import cds.aladin.UWSJob;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class UWSReader
implements XMLConsumer {
    private boolean inUWSJobTag = false;
    private boolean inParameters = false;
    private boolean inResults = false;
    private boolean inErrorSummary = false;
    private boolean inJobInfo = false;
    private String tag;
    private UWSJob uwsJob;
    private String paramId;

    public boolean load(InputStream in, UWSJob job) throws Exception {
        this.uwsJob = job;
        XMLParser xmlParser = new XMLParser(this);
        boolean result = false;
        MyInputStream inputStream = null;
        this.resetFlags(this.uwsJob);
        try {
            inputStream = new MyInputStream(in);
            result = xmlParser.parse(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return result;
    }

    private void resetFlags(UWSJob job) {
        this.inUWSJobTag = false;
        job.setParameters(new HashMap<String, String>());
        job.setResults(new HashMap<String, String>());
    }

    @Override
    public void startElement(String name, Hashtable atts) {
        if (name.equals("job")) {
            this.inUWSJobTag = true;
            this.tag = "";
            if (atts.containsKey("version")) {
                this.uwsJob.setVersion(Double.parseDouble((String)atts.get("version")));
            }
        } else if (this.inUWSJobTag) {
            if (name.equals("jobId")) {
                this.tag = "jobId";
            } else if (name.equals("runId")) {
                this.tag = "runId";
            } else if (name.equals("ownerId")) {
                this.tag = "ownerId";
            } else if (name.equals("phase")) {
                this.tag = "phase";
            } else if (name.equals("quote")) {
                this.tag = "quote";
            } else if (name.equals("startTime")) {
                this.tag = "startTime";
            } else if (name.equals("endTime")) {
                this.tag = "endTime";
            } else if (name.equals("creationTime")) {
                this.tag = "creationTime";
            } else if (name.equals("executionDuration")) {
                this.tag = "executionDuration";
            } else if (name.equals("destruction")) {
                this.tag = "destruction";
            } else if (name.equals("parameters")) {
                this.inParameters = true;
                this.tag = "parameters";
            } else if (this.inParameters && name.equals("parameter")) {
                if (atts.containsKey("id")) {
                    this.paramId = (String)atts.get("id");
                }
                this.tag = "parameter";
            } else if (name.equals("results")) {
                this.inResults = true;
                this.tag = "results";
            } else if (this.inResults && name.equals("result")) {
                this.tag = "result";
                if (atts != null && atts.size() > 0) {
                    String idForResultsMap = null;
                    idForResultsMap = atts.containsKey("id") ? (String)atts.get("id") : "result" + this.uwsJob.getResults().size();
                    if (atts.containsKey("xlink:href")) {
                        this.uwsJob.getResults().put(idForResultsMap, (String)atts.get("xlink:href"));
                    } else if (atts.containsKey("href")) {
                        this.uwsJob.getResults().put(idForResultsMap, (String)atts.get("href"));
                    } else if (atts.size() > 0) {
                        Object object;
                        Set potentialHrefs = atts.keySet();
                        String potentialHref = null;
                        Iterator iterator = potentialHrefs.iterator();
                        while (iterator.hasNext() && !(potentialHref = String.valueOf(object = iterator.next())).contains("href") && !potentialHref.contains("HREF")) {
                        }
                        if (potentialHref != null && atts.get(potentialHref) != null) {
                            this.uwsJob.getResults().put(idForResultsMap, (String)atts.get(potentialHref));
                        }
                    }
                }
            } else if (name.equals("errorSummary")) {
                String hasDetail;
                this.tag = "errorSummary";
                this.inErrorSummary = true;
                if (atts.containsKey("type")) {
                    this.uwsJob.setErrorType((String)atts.get("type"));
                }
                if (atts.containsKey("hasDetail") && (hasDetail = (String)atts.get("hasDetail")).equalsIgnoreCase("true")) {
                    this.uwsJob.setHasErrorDetail(true);
                }
            } else if (this.inErrorSummary && name.equals("message")) {
                this.tag = "message";
            } else if (name.equals("jobInfo")) {
                this.tag = "jobInfo";
                this.inJobInfo = true;
            }
        }
    }

    @Override
    public void endElement(String name) {
        if (this.inUWSJobTag && name.equals("job")) {
            this.inUWSJobTag = false;
        } else if (this.inParameters && name.equals("parameters")) {
            this.inParameters = false;
            this.tag = "";
        } else if (this.inResults && name.equals("results")) {
            this.inResults = false;
            this.tag = "";
        } else if (this.inJobInfo && name.equals("jobInfo")) {
            this.inJobInfo = false;
            this.tag = "";
        } else if (this.inUWSJobTag) {
            this.tag = "";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws Exception {
        String data = new String(ch, start, length);
        if (this.inUWSJobTag) {
            if (this.inParameters && this.tag.equals("parameter")) {
                this.uwsJob.getParameters().put(this.paramId, data);
            } else if (this.inErrorSummary && this.tag.equals("message")) {
                this.uwsJob.setErrorMessage(data);
            } else if (this.inJobInfo) {
                this.uwsJob.getJobInfoXml().append(data);
            } else {
                this.setOthers(this.tag, data);
            }
        }
    }

    public void setOthers(String tag, String data) {
        if (tag.equals("jobId")) {
            this.uwsJob.setJobId(data);
        } else if (tag.equals("runId")) {
            this.uwsJob.setRunId(data);
        } else if (tag.equals("ownerId")) {
            this.uwsJob.setOwnerId(data);
        } else if (tag.equals("phase")) {
            this.uwsJob.setCurrentPhase(data);
        } else if (tag.equals("quote")) {
            this.uwsJob.setQuote(data);
        } else if (tag.equals("startTime")) {
            this.uwsJob.setStartTime(data);
        } else if (tag.equals("endTime")) {
            this.uwsJob.setEndTime(data);
        } else if (tag.equals("creationTime")) {
            this.uwsJob.setCreationTime(data);
        } else if (tag.equals("executionDuration")) {
            this.uwsJob.setExecutionDuration(Long.parseLong(data));
        } else if (tag.equals("destruction")) {
            this.uwsJob.setDestructionTime(data);
        }
    }

    public boolean isInUWSJobTag() {
        return this.inUWSJobTag;
    }

    public void setInUWSJobTag(boolean inUWSJobTag) {
        this.inUWSJobTag = inUWSJobTag;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

